/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import jgamebase.Const;
import jgamebase.db.Db;
import jgamebase.db.Table;
import jgamebase.gui.Gui;
import jgamebase.model.Databases;
import jgamebase.tools.FileTools;
import org.hibernate.Session;
import org.hibernate.exception.GenericJDBCException;

public class Import {
    public static void csv2Db() throws Exception {
        String dbName = Databases.getCurrent().getName();
        File dbPath = Databases.getCurrent().getPath();
        Db.close();
        new File(dbPath, "Database");
        File dbBackupDir = new File(dbPath, "Database_bck");
        if (dbBackupDir.exists()) {
            FileTools.deleteAll(dbBackupDir);
        }
        Db.init(dbName, true);
        Import.csv2Db(new File(dbPath, "Export"));
        Db.init(dbName, false);
    }

    public static void csv2Db(File file) throws Exception {
        String dbPath = file.getParentFile().getAbsolutePath();
        Const.log.info((Object)("Starting import of database: " + file.getParentFile().getName()));
        Session session = Db.getSession();
        session.beginTransaction();
        for (String table : Table.getNames()) {
            try {
                Import.importTable(session, dbPath, table);
            }
            catch (Exception e) {
                Const.log.info((Object)"");
                Const.log.info((Object)("  Switching to alternate import method because of the following exception: " + e));
                Import.importTableLineByLine(session, dbPath, table);
            }
            Const.log.info((Object)("  Table '" + table + "': " + session.createSQLQuery("select count(*) from " + table).uniqueResult() + " rows imported.\n"));
        }
        session.getTransaction().commit();
        Const.log.info((Object)"Import of database successfully finished.");
        Db.reorganize();
        Db.close();
    }

    private static void importTable(Session session, String dbPath, String tableName) throws Exception {
        String csvFilename = String.valueOf(dbPath) + "/" + "Export" + "/" + tableName + ".csv";
        if (!new File(csvFilename).canRead()) {
            String error = "CSV file '" + csvFilename + "' not found!";
            Gui.displayErrorDialog(error);
            throw new Exception(error);
        }
        if (new File(csvFilename).length() == 0L) {
            String warning = "CSV file '" + csvFilename + "' is empty!";
            if (!(tableName.equals(Table.MUSIC.getName()) || tableName.equals(Table.VIEWDATA.getName()) || tableName.equals(Table.VIEWFILTERS.getName()))) {
                Gui.displayWarningDialog(warning);
            }
        } else {
            Const.log.info((Object)("  Importing data from csv file '" + csvFilename + "' into table '" + tableName.toUpperCase() + "'."));
            Import._importTable(session, tableName, csvFilename);
        }
        session.flush();
    }

    private static void importTableLineByLine(Session session, String dbPath, String tablename) throws Exception {
        String csvFilename = String.valueOf(dbPath) + "/" + "Export" + "/" + tablename + ".csv";
        if (!new File(csvFilename).canRead()) {
            String error = "CSV file '" + csvFilename + "' not found!";
            Gui.displayErrorDialog(error);
            throw new Exception(error);
        }
        if (new File(csvFilename).length() == 0L) {
            String error = "CSV file '" + csvFilename + "' is empty!";
            if (!tablename.equals(Table.MUSIC.getName())) {
                Gui.displayErrorDialog(error);
                throw new Exception(error);
            }
        } else {
            String singleLineFilename = String.valueOf(csvFilename) + ".sle";
            Const.log.info((Object)("  Importing data from csv file '" + csvFilename + "' into table '" + tablename.toUpperCase() + "' line by line."));
            CSVReader reader = new CSVReader((Reader)new FileReader(csvFilename), ',', '\"', '\u0010');
            List lines = reader.readAll();
            int count = 0;
            for (Object[] line : lines) {
                CSVWriter writer = new CSVWriter((Writer)new FileWriter(singleLineFilename));
                writer.writeNext((String[])line);
                writer.close();
                try {
                    ++count;
                    Import._importTable(session, tablename, singleLineFilename);
                    System.out.print(".");
                }
                catch (SQLException | GenericJDBCException e) {
                    Const.log.warn((Object)"");
                    Const.log.warn((Object)("  Table '" + tablename.toUpperCase() + "': skipped line #" + count + "/" + lines.size()));
                    Const.log.warn((Object)("  " + Arrays.toString(line)));
                    Const.log.warn((Object)"  because of the following exception:");
                    Const.log.warn((Object)("  " + e.getCause()));
                }
                new File(singleLineFilename).delete();
            }
        }
        session.flush();
    }

    private static void _importTable(Session session, String tableName, String csvFilename) throws SQLException {
        session.doWork(connection -> {
            CallableStatement cs = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_IMPORT_TABLE(?,?,?,?,?,?,?)");
            cs.setString(1, null);
            cs.setString(2, tableName.toUpperCase());
            cs.setString(3, csvFilename);
            cs.setString(4, null);
            cs.setString(5, null);
            cs.setString(6, null);
            cs.setShort(7, (short)0);
            cs.execute();
            cs.close();
        });
    }
}

